@extends('layouts.backend')

@section('extra_css')
    <meta name="token" id="token" value="{{ csrf_token() }}">
    <link rel="stylesheet" href="{{ asset('assets/vendors/iCheck/skins/flat/green.css') }}">
    <link rel="stylesheet" href="//code.jquery.com/ui/1.12.0/themes/base/jquery-ui.css">
    <link rel="stylesheet" href="{{ asset('assets/vendors/bootstrap-tagsinput/dist/bootstrap-tagsinput.css') }}">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.3/css/select2.min.css" rel="stylesheet"/>

    <link rel="stylesheet" href="{{ asset('assets/css/custom.min.css') }}">
    <link rel="stylesheet" href="{{ asset('assets/vendors/google-code-prettify/bin/prettify.min.css') }}">
    <link rel="stylesheet" type="text/css"
          href="https://cdnjs.cloudflare.com/ajax/libs/jqueryui/1.12.1/jquery-ui.min.css">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/tag-it/2.0/css/jquery.tagit.min.css" rel="stylesheet"
          type="text/css">
    <style>
        .ui-autocomplete {
            top: 65px !important;
            left: 10px !important;
        }
    </style>
@endsection



@section('extra_js')
    <script src="{{ asset('assets/vendors/parsleyjs/dist/parsley.min.js') }}"></script>
    <script src="{{ asset('vendor/laravel-filemanager/js/lfm.js') }}"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.3/js/select2.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jqueryui/1.12.1/jquery-ui.min.js" type="text/javascript"
            charset="utf-8"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/tag-it/2.0/js/tag-it.min.js" type="text/javascript"
            charset="utf-8"></script>
    <script>

        $(document).ready(function (){


            $("#myTags").tagit({

                itemName: 'question',
                fieldName: 'tags',
                removeConfirmation: true,
                allowSpaces: true,
                // tagSource: ['foo', 'bar']
                tagSource: [<?php echo '"'.implode('","', $tags).'"' ?>],
                autocomplete: {
                    appendTo: ".ui-front",
                    delay: 0,
                    minLength: 2,
                    source: this.tagSource

                }
            });
            $(".ui-autocomplete").appendTo($(".ui-front"));


            let post_status = $("#post_status");
            post_status.click(function () {
                if(post_status.is(':checked')){
                    post_status.val(1);  // checked
                }else {
                    post_status.val(0);
                }
            });

            let watermark = $("#watermark");
            watermark.click(function () {
                if (watermark.is(':checked')) {
                    watermark.val(1);  // checked
                } else {
                    watermark.val(0);
                }
            });


            let sticky = $("#sticky");
            if (sticky.is(':checked')) {
                $("#sticky_position_input").css("display", "block");
            }
            sticky.on('click', function () {
                if (sticky.is(':checked')) {
                    sticky.val(1);  // checked
                    $("#sticky_position_input").css("display", "block");
                } else {
                    sticky.val(0);
                    $("#sticky_position_input").css("display", "none");
                    $("#sticky_position").val('');
                }
            });


            let show_user_photo = $("#show_user_photo");
            show_user_photo.click(function () {
                if(show_user_photo.is(':checked')){
                    show_user_photo.val(1);  // checked
                }else {
                    show_user_photo.val(0);
                }
            });







            $('#lfm').filemanager('image');
            $('#lfm2').filemanager('image');



            $('#category_list').select2();
            $('#division_list').select2({
                    divisions: true
                }
            );

            $('#division_list').on('change', function (e) {
                console.log(e);

                var division_id = e.target.value;

                /* Ajax */

                $.get("{{ route('division.district') }}/" + division_id, function (data) {
                    /*success data*/
                    $('#district_list').empty();
                    $.each(data, function (index, districtObj) {
                        $('#district_list').append('<option value="' + districtObj.id + '">' + districtObj.name + '</option>')
                    })
                })
            });

            <!-- /jQuery Tags Input -->


        })


    </script>
@endsection


@section('content')
    <div class="right_col" role="main">
        <div class="">
            <div class="page-title">
                <div class="title_left">
                    <h3>Tags</h3>
                </div>

                <div class="title_right">
                    <div class="col-md-5 col-sm-5 col-xs-12 form-group pull-right top_search">
                        <div class="input-group">
                            <input type="text" class="form-control" placeholder="Search for...">
                            <span class="input-group-btn">
                      <button class="btn btn-default" type="button">Go!</button>
                    </span>
                        </div>
                    </div>
                </div>
            </div>

            <div class="clearfix"></div>

            <div class="row">
                <div class="col-md-12">
                    @if (count($errors) > 0)
                        @foreach ($errors->all() as $error)
                            <div class="alert alert-danger alert-dismissible fade in" role="alert">
                                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                    <span aria-hidden="true">&times;</span>
                                </button> {{ $error }}</div>
                        @endforeach
                    @endif

                    @if (Session::get('message'))
                        <div class="alert alert-info alert-dismissible fade in" role="alert">
                            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button> {{ Session::get('message') }}
                        </div>
                    @endif
                </div>

                <form method="post" action="{{ route('post.update', ['id' => $postEdit->id]) }}" data-parsley-validate=""
                      class="form-horizontal form-label-left" novalidate="">
                    {{ csrf_field() }}
                    <input type="hidden" name="_method" value="PUT">

                    <div class="col-md-8 col-sm-12 col-xs-12">


                        <div class="x_panel">
                            <div class="x_content">

                                <br/>


                                <div class="col-md-12">
                                    <div class="form-horizontal form-label-left">
                                        <div class="form-group">
                                            <label>Headline</label>
                                            <input name="headline" value="{{ $postEdit->headline }}" type="text" class="form-control" required="required">
                                        </div>
                                    </div>
                                </div>{{--headline--}}

                                <div class="col-md-12">
                                    <div class="form-horizontal form-label-left">
                                        <div class="form-group">
                                            <label> Inner Page Headline</label>
                                            <input name="single_page_headline" value="{{ $postEdit->single_page_headline }}" type="text" class="form-control">
                                        </div>
                                    </div>
                                </div>{{--single_page_headline--}}

                                <div class="col-md-12">
                                    <div class="form-horizontal form-label-left">
                                        <div class="form-group">
                                            <label>Sub Headline</label>
                                            <input name="sub_headline" type="text"  value="{{ $postEdit->sub_headline }}" class="form-control">
                                        </div>
                                    </div>
                                </div>{{--sub_headline--}}

                                <div class="col-md-12">
                                    <div class="form-horizontal form-label-left">
                                        <div class="form-group">
                                            <label>Excerption</label>
                                            <input name="excerpt" type="text"  value="{{ $postEdit->excerpt }}" class="form-control">
                                        </div>
                                    </div>
                                </div>{{--Excerpt--}}

                                <div class="col-md-12">
                                    <div class="form-horizontal form-label-left">
                                        <div class="form-group">
                                            <label>Facebook Description</label>
                                            <input name="facebook_description" value="{{ $postEdit->facebook_description }}" type="text" class="form-control">
                                        </div>
                                    </div>
                                </div>{{--Excerpt--}}

                                <div class="col-md-12">
                                    <div class="form-horizontal form-label-left">
                                        <div class="form-group">
                                            <label>Post Content</label>
                                            <script src="//cdn.tinymce.com/4/tinymce.min.js"></script>
                                            <textarea id="post_content" name="post_content"
                                                      class="form-control my-editor"
                                                      rows="15">{{ $postEdit->post_content }}</textarea>
                                            <script>
                                                var editor_config = {
                                                    path_absolute: "/",
                                                    selector: "#post_content",
                                                    plugins: [
                                                        "textcolor advlist autolink lists link image charmap print preview hr anchor pagebreak",
                                                        "searchreplace wordcount visualblocks visualchars code fullscreen",
                                                        "insertdatetime media nonbreaking save table directionality",
                                                        "emoticons template paste textcolor colorpicker textpattern"
                                                    ],
                                                    toolbar: "forecolor backcolor insertfile undo redo | styleselect | bold italic | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | link image media",
                                                    relative_urls: false,
                                                    file_browser_callback: function (field_name, url, type, win) {
                                                        var x = window.innerWidth || document.documentElement.clientWidth || document.getElementsByTagName('body')[0].clientWidth;
                                                        var y = window.innerHeight || document.documentElement.clientHeight || document.getElementsByTagName('body')[0].clientHeight;

                                                        var cmsURL = editor_config.path_absolute + 'laravel-filemanager?field_name=' + field_name;
                                                        if (type == 'image') {
                                                            cmsURL = cmsURL + "&type=Images";
                                                        } else {
                                                            cmsURL = cmsURL + "&type=Files";
                                                        }

                                                        tinyMCE.activeEditor.windowManager.open({
                                                            file: cmsURL,
                                                            title: 'Filemanager',
                                                            width: x * 0.8,
                                                            height: y * 0.8,
                                                            resizable: "yes",
                                                            close_previous: "no"
                                                        });
                                                    }
                                                };

                                                tinymce.init(editor_config);
                                            </script>
                                        </div>
                                    </div>
                                </div>{{--content--}}
                                <div class="clearfix"></div>
                                <div class="ln_solid"></div>
                                {{--<div class="form-group">
                                    <div class="col-md-3 col-sm-12 col-xs-12">

                                        <button type="submit" class="text-center btn btn-success submit btn-block">Submit
                                        </button>

                                    </div>
                                </div>--}}
                            </div>
                        </div>
                    </div>

                    <div class="col-md-4">
                        <div class="x_panel">
                            <div class="x_content">
                                <div class="row">

                                    <div class="col-md-6">
                                        <div class="form-horizontal form-label-left">
                                            <div class="form-group">
                                                <label>Lead News?</label>
                                                <input type="checkbox" id="sticky" value="{{ $postEdit->sticky }}"  name="sticky" @if($postEdit->sticky == 1) checked="checked" @endif>
                                            </div>
                                        </div>
                                    </div>{{--Sticky--}}
                                    <?php $leadpost =\App\LeadPosts::where('post_id', $postEdit->id)->first(); ?>
                                    <div class="col-md-6">
                                        <div class="form-horizontal form-label-left">
                                            <div class="form-group" style="display: none" id="sticky_position_input">
                                                <label style="display: inline">position
                                                    <input type="number" id="sticky_position" @if($leadpost) value="{{ $leadpost->position }}" @endif name="sticky_position">
                                                </label>
                                            </div>
                                        </div>
                                    </div>{{--sticky_position--}}

                                </div>

                                <div class="row">
                                    <div class="col-md-9">
                                        <div class="form-horizontal form-label-left">
                                            <div class="form-group">
                                                <label>Featured Image</label>
                                                <div class="input-group">
                                                    <input id="thumbnail2" class="form-control" type="text"
                                                           name="featured_image" value="{{ $postEdit->featured_image }}">
                                                    <span class="input-group-btn">
                                                <a id="lfm" data-input="thumbnail2" data-preview="holder"
                                                   class="btn btn-primary">
                                                  <i class="fa fa-picture-o"></i> Choose
                                                </a>
                                              </span>

                                                </div>
                                                <img id="holder" style="margin-top:15px;max-height:100px;" @if($postEdit->featured_image) src="{{ $postEdit->featured_image }}" @endif>
                                            </div>

                                        </div>
                                    </div>{{--featured_image--}}
                                    <div class="col-md-3">
                                        <div class="form-group">
                                            <div class="checkbox" style="padding-top: 30px;">
                                                <label>
                                                    <input type="checkbox"  id="watermark" value="{{ $postEdit->watermark }}" @if($postEdit->watermark == 1) checked="checked" @endif name="watermark">
                                                    watermark
                                                </label>
                                            </div>
                                        </div>

                                    </div>{{--watermark--}}


                                </div>

                                <div class="row">
                                    <div class="col-md-12">
                                        <div class="form-horizontal form-label-left">
                                            <div class="form-group">
                                                <label>Featured Image Caption</label>
                                                <input name="featured_image_caption" value="{{ $postEdit->featured_image_caption }}" type="text" class="form-control">
                                            </div>
                                        </div>
                                    </div>{{--featured_image_caption--}}

                                </div>


                                <div class="row">
                                    <div class="col-md-12">
                                        <div class="form-horizontal form-label-left">
                                            <div class="form-group">
                                                <label>Publisher Name</label>
                                                <input name="publisher_name" type="text" value="{{ $postEdit->publisher_name }}" class="form-control">
                                            </div>
                                        </div>
                                    </div>{{--Writer Name--}}
                                    <div class="col-md-6">
                                        <div class="form-horizontal form-label-left">
                                            <div class="form-group">
                                                <label>Reporter Photo</label>
                                                <div class="input-group">
                                                    <input id="thumbnail" class="form-control" value="{{ $postEdit->reporter_photo }}" type="text"
                                                           name="reporter_photo">
                                                    <span class="input-group-btn">
                                                        <a id="lfm2" data-input="thumbnail" data-preview="holder2"
                                                           class="btn btn-primary">
                                                          <i class="fa fa-picture-o"></i> Choose
                                                        </a>
                                                    </span>

                                                </div>
                                                <img id="holder2" style="margin-top:15px;max-height:100px;" @if($postEdit->reporter_photo) src="{{ $postEdit->reporter_photo }}" @endif>
                                            </div>

                                        </div>
                                    </div>{{--Show Publisher Photo--}}                                   
                                </div>






                                <div class="row">
                                    <div class="col-md-12">
                                        <div class="form-group ui-front">
                                            <label for="title">Tags</label>
                                            <input type="text" id="myTags" value="{{ implode(",",$postEdit->TagList()) }}" name="tag_list"
                                                   class="form-control ">

                                        </div>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-md-12">

                                        <div class="form-group">
                                            {!! Form::label('categories', 'Categories:') !!}
                                            {!! Form::select('category_id[]', $categories, $postEdit->CategoryList(), ['required', 'id' => 'category_list', 'class' => 'form-control', 'multiple']) !!}

                                        </div>
                                    </div>{{--categories--}}
                                </div>

                                <div class="row">
                                    <div class="col-md-12">
                                        <div class="row">
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    {!! Form::label('divisions', 'Divisions:') !!}
                                                    {!! Form::select('division_id[]', $divisions, null, ['id' => 'division_list', 'class' => 'form-control']) !!}

                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label for="district_list">Select District</label>

                                                    <select id="district_list" name="district_id[]" class="form-control">
                                                        @if($postEdit->District()->first())
                                                            <option value="{{ $postEdit->District()->first()->id }}">{{ $postEdit->District()->first()->name }}</option>
                                                        @endif

                                                    </select>
                                                </div>
                                            </div>
                                        </div>

                                    </div>{{--division-district--}}
                                </div>
								<div class="row">
								 <div class="col-md-12">
                                        <div class="form-horizontal form-label-left">
                                            <div class="form-group">
                                                <label for="post_status">Save as Draft</label>

                                                <input id="post_status" type="checkbox" value="{{ $postEdit->post_status }}" name="post_status" @if($postEdit->post_status == 0) checked="checked" @endif>
                                            </div>
                                        </div>
                                    </div>
									</div>
									{{--post_status--}}

<br>
								<div class="row">
                                    <div class="form-group">
                                    <div class="col-md-12 col-sm-6 col-xs-6">
                                     <button type="submit" class="btn btn-success" style="padding: 8px 32px; font-size: 23px; ">Update</button>
                                    <a href="/admin365/post-settings" class="btn btn-info" style="background-color: #EE811A; border: 1px solid #EE811A; padding: 8px 32px; font-size: 23px;">Cancel</a>
                                    </div>
                                </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </form>


            </div>
        </div>
    </div>


    <!-- Trigger the modal with a button -->


@endsection



