@extends('layouts.backend')

@section('extra_css')
    <meta name="token" id="token" value="{{ csrf_token() }}">
    <link rel="stylesheet" href="{{ asset('assets/css/custom.min.css') }}">
    <link rel="stylesheet" href="{{ asset('assets/vendors/google-code-prettify/bin/prettify.min.css') }}">
@endsection


@section('content')
    <div class="right_col" role="main">
        <div class="">
            <div class="page-title">
                <div class="title_left">
                    <h3>All Posts</h3>
                </div>

                <div class="title_right">
                    <div class="col-md-5 col-sm-5 col-xs-12 form-group pull-right top_search">
                        <div class="input-group">
                            <input type="text" class="form-control" placeholder="Search for...">
                            <span class="input-group-btn">
                      <button class="btn btn-default" type="button">Go!</button>
                    </span>
                        </div>
                    </div>
                </div>
            </div>

            <div class="clearfix"></div>


            <div class="row" id="manage-subcategory">

                <div class="col-md-12">
                    @if (count($errors) > 0)
                        @foreach ($errors->all() as $error)
                            <div class="alert alert-danger alert-dismissible fade in" role="alert">
                                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                    <span aria-hidden="true">&times;</span>
                                </button> {{ $error }}</div>
                        @endforeach
                    @endif

                    @if (Session::get('message'))
                        <div class="alert alert-info alert-dismissible fade in" role="alert">
                            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button> {{ Session::get('message') }}
                        </div>
                    @endif
                </div>

                <div class="col-md-12 col-sm-12 col-xs-12">
                    <div class="x_panel">
                        <div class="x_title">
                            <h2><a href="{{ route('post.create') }}"><button type="button" class="btn btn-success"><i class="fa fa-plus"></i> Add Post</button></a>
                                <small>(Manage Your Posts)</small>
                            </h2>
                            <ul class="nav navbar-right panel_toolbox">
                                <li><a class="collapse-link"><i class="fa fa-chevron-up"></i></a>
                                </li>
                                <li class="dropdown">
                                    <a href="#" class="dropdown-toggle" data-toggle="dropdown" role="button"
                                       aria-expanded="false"><i class="fa fa-wrench"></i></a>
                                    <ul class="dropdown-menu" role="menu">
                                        <li><a href="#">Settings 1</a>
                                        </li>
                                        <li><a href="#">Settings 2</a>
                                        </li>
                                    </ul>
                                </li>
                                <li><a class="close-link"><i class="fa fa-close"></i></a>
                                </li>
                            </ul>
                            <div class="clearfix"></div>
                        </div>
                        <div class="x_content">
                            {{ $posts->links() }}
                            <table class="table table-bordered" id="category_table">
                                <thead>
                                <tr>
                                    <th class="col-md-1">ID</th>
                                    <th class="col-md-3">Headline</th>
                                    <th class="col-md-2">Time</th>
                                    <th class="col-md-1">Publisher</th>
                                    <th class="col-md-2">Category</th>
                                    <th class="col-md-1">Total Hit</th>

                                    <th class="col-md-2">Action</th>
                                </tr>
                                </thead>
                                <tbody>

                                @foreach($posts as $post)
                                    <tr>
                                        <td class="col-md-1">{{ $post->id }}</td>
                                        <td class="col-md-3">{{ $post->headline}}</td>
                                        <td class="col-md-2">
                                            {{ Carbon\Carbon::createFromFormat('Y-m-d H:i:s', $post->created_at)->format('H:i/d-m') }}
                                        </td>
                                        <td class="col-md-1">{{ $post->User ? $post->User->name : '' }}</td>
                                       <td class="col-md-2">
                                            @foreach($post->Category->lists('name')->all() as $cat)
                                                {{ $cat}},
                                            @endforeach
                                        </td>
                                        <td class="col-md-1">{{ $post->view_count }}</td>

                                        <td class="col-md-12" style="display: inline-flex;">
                                            <a target="_blank"
                                               href="{{ news_url($post) }}"
                                               class="btn btn-sm btn-success" role="button"><i
                                                        class="fa fa-eye"></i></a>
                                            <a href="{{ route('post.edit', ['id' => $post->id]) }}" class="btn btn-sm btn-success" role="button"><i class="fa fa-edit"></i></a>
                                            <form id="post-delete" action="{{ route('post.destroy', ['id' => $post->id]) }}"
                                                  method="post">
                                                <input type="hidden" name="_method"
                                                       value="DELETE">
                                                {{ csrf_field() }}
                                                <button type="submit"
                                                        class="btn btn-sm btn-danger permanently">
                                                    <i class="fa fa-times"></i></button>

                                            </form>
                                        </td>
                                    </tr>
                                @endforeach


                                </tbody>

                            </table>

                            {{ $posts->links() }}

                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>


    <!-- Trigger the modal with a button -->


@endsection

@section('extra_js')
    <script src="{{ asset('assets/vendors/parsleyjs/dist/parsley.min.js') }}"></script>
    <script>
        $('#post-delete').submit(function() {
            var c = confirm("Click OK to continue?");
            return c; //you can just return c because it will be true or false
        });
    </script>
@endsection

